// VVV Bookmark Extension - Background Service Worker

// Track login tab
let loginTabId = null;

// ログインタブを追跡するためのリスナー
chrome.tabs.onCreated.addListener((tab) => {
  if (tab.pendingUrl && tab.pendingUrl.includes('login?extension=1')) {
    loginTabId = tab.id;
  }
});

// タブ更新を監視してログイン完了を検出
chrome.tabs.onUpdated.addListener(async (tabId, changeInfo, tab) => {
  // ログイン完了（ハッシュ変更）またはページ読み込み完了をチェック
  const isLoginSuccess = changeInfo.url && changeInfo.url.includes('extension-login-success');
  const isPageComplete = changeInfo.status === 'complete';

  // ログインタブIDの更新
  if (tab.url && tab.url.includes('login?extension=1')) {
    loginTabId = tabId;
  }

  if ((tabId === loginTabId) && (isLoginSuccess || isPageComplete)) {
    // VVVドメインのページかチェック
    if (tab.url && (tab.url.includes('vvv.jkjk.uk') || tab.url.includes('localhost:8000'))) {
      try {
        // scripting APIでlocalStorageからトークンを取得
        const results = await chrome.scripting.executeScript({
          target: { tabId: tabId },
          func: () => {
            const token = localStorage.getItem('vvv_extension_token');
            if (token) {
              // 取得できたらクリアする（セキュリティのため）
              localStorage.removeItem('vvv_extension_token');
              return token;
            }
            return null;
          }
        });

        if (results && results[0] && results[0].result) {
          const token = results[0].result;
          await chrome.storage.local.set({ accessToken: token });
          console.log('VVV Extension: Token saved successfully!');
          showNotification('Login Success', 'Click the icon to save pages.');

          // 成功したらタブID追跡をリセット
          loginTabId = null;
        }
      } catch (err) {
        console.error('VVV Extension: Error reading token', err);
      }
    }
  }
});

// タブが閉じられたらトラッキングを解除
chrome.tabs.onRemoved.addListener((tabId) => {
  if (tabId === loginTabId) {
    loginTabId = null;
  }
});

// 通知表示
function showNotification(title, message) {
  chrome.notifications.create({
    type: 'basic',
    iconUrl: 'icon128.png',
    title: title,
    message: message
  });
}
